class X2Ability_BioticVanguardSet extends X2Ability config(GameData_SoldierSkills);

var config int ChargeCooldown;

var config int BACKLASH_COOLDOWN;

var config int NovaCooldown;

var config int OverdriveCooldown;

var config int NOVA_RADIUS;

var config int NOVA_PSIMULTI;

var config int NOVA_MINRADIUS;

var config int NOVA_MAXRADIUS;

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;

	Templates.AddItem(Charge()); //charge into an enemy, rolling for disorienting and stun on nearby enemies. Target itself will be damaged.
	Templates.AddItem(ChargeGroupStun()); //this triggers from the unit that has just charged.

	Templates.AddItem(Backlash()); // Reflects projectile damage back to the attacker as long as a biotic has shield points remaining. This consumes a Biotic's turn.
	Templates.AddItem(Nova()); //Consumes 3 shield points to deliver a devastating blast against nearby enemies.
	Templates.AddItem(Aegis()); // Biotic barriers now block all overflow damage.
	Templates.AddItem(PurePassive('RM_BioticNerves', "img:///XPerkIconPack.UIPerk_lightning_x2", false, 'eAbilitySource_Psionic')); //The biotic has reduced cooldowns on all biotic powers. 
	Templates.AddItem(BioticOverdrive()); //like SPARK's Overdrive, but for a Biotic. Resets all cooldowns when activated.
	Templates.AddItem(PurePassive('RM_ExplodingBiotics', "img:///XPerkIconPack.UIPerk_star_cycle", false, 'eAbilitySource_Psionic')); //All AOE abilities the biotic has have their radius increased by 2. AOE abilities will also disorient if not reliant on a psi check.


	return Templates;
}


static function X2AbilityTemplate BioticOverdrive()
{
	local X2AbilityTemplate						Template;
	local X2AbilityCooldown_Bonus                     Cooldown;
	local X2Effect_GrantActionPoints            PointEffect;
	local X2Effect_Persistent			        ActionPointPersistEffect;
	local X2Effect_ReduceCooldowns				ReduceCooldownEffect;

	Template= new(None, string('RM_BioticOverdrive')) class'X2AbilityTemplate'; Template.SetTemplateName('RM_BioticOverdrive');;;
	Template.RemoveTemplateAvailablility(Template.BITFIELD_GAMEAREA_Multiplayer);

	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.OverdriveCooldown;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	Template.AbilityCosts.AddItem(default.FreeActionCost);

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.Hostility = eHostility_Neutral;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_chevron_x3";

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);

	PointEffect = new class'X2Effect_GrantActionPoints';
	PointEffect.NumActionPoints = 1;
	PointEffect.PointType = class'X2CharacterTemplateManager'.default.StandardActionPoint;
	Template.AddTargetEffect(PointEffect);

	// A persistent effect for the effects code to attach a duration to
	ActionPointPersistEffect = new class'X2Effect_Persistent';
	ActionPointPersistEffect.EffectName = 'RM_BioticOverdrive';
	ActionPointPersistEffect.BuildPersistentEffect( 1, false, true, false, eGameRule_PlayerTurnEnd );
	Template.AddTargetEffect(ActionPointPersistEffect);

	ReduceCooldownEffect = new class'X2Effect_ReduceCooldowns';
	ReduceCooldownEffect.ReduceAll = true;
	Template.AddTargetEffect(ReduceCooldownEffect);

	Template.bShowActivation = true;
	Template.bSkipFireAction = true;

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;

	return Template;
}


static function X2AbilityTemplate Aegis()
{
	local X2AbilityTemplate                 Template;	
	local X2Effect_Aegis					AegisEffect;
	
	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Aegis');	
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_defense";
	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_NeverShow;
	Template.bDisplayInUITacticalText = false;
	Template.Hostility = eHostility_Neutral;
	Template.bIsPassive = true;

	Template.AbilityToHitCalc = default.DeadEye;
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilityTriggers.AddItem(default.UnitPostBeginPlayTrigger);		

	AegisEffect = new class'X2Effect_Aegis';
	AegisEffect.BuildPersistentEffect(1, true, true,, eGameRule_TacticalGameStart);
	AegisEffect.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, true,,Template.AbilitySourceName);
	Template.AddTargetEffect(AegisEffect);

	Template.bCrossClassEligible = false;

	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;

	return Template;
}


static function X2AbilityTemplate Nova()
{
 
 	local X2AbilityTemplate                 Template;
	local X2AbilityTrigger_PlayerInput InputTrigger;
 // 	local X2Condition_UnitValue				ShooterCondition;	 //here
//	local X2Condition_UnitEffects			ShooterEffects;
	local X2Effect_Persistent               DisorientedEffect;
	local X2AbilityMultiTarget_Radius_RMPsi RadiusMultiTarget;
	local X2Condition_UnitProperty          HealTargetCondition;
	//local X2Condition_UnitProperty						SourceNotConcealedCondition;
	local X2Condition_AbilityProperty   ExplodingCondition;
	local X2Effect_ApplyWeaponDamage        ChargeDamageEffect, BonusDamageEffect;
	local X2Effect_NovaShieldEffect			ShieldDamageEffect;
	local X2Effect_ApplyWeaponDamage    RuptureEffect;
	local X2Condition_AbilityProperty   ExposeCondition, DevastateCondition;
	local X2Effect_Reave					ReaveEffect;
	local X2Condition_AbilityProperty		ConsumeCondition;
	local X2Effect_AdditionalAnimSets						AnimSets;
	local X2Condition_UnitStatCheck         ShieldCondition;
	local X2AbilityCooldown_Bonus Cooldown;
	local X2AbilityCost_ActionPoints ActionPointCost;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Nova');

	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.Hostility = eHostility_Offensive;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_blaze";
	
	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	Template.AbilityCosts.AddItem(ActionPointCost);

	InputTrigger = new class'X2AbilityTrigger_PlayerInput';
	Template.AbilityTriggers.AddItem(InputTrigger);

	Template.AbilityToHitCalc = default.DeadEye;

	RadiusMultiTarget = new class'X2AbilityMultiTarget_Radius_RMPsi';
	RadiusMultiTarget.fTargetRadius = default.NOVA_RADIUS;
	RadiusMultiTarget.bIgnoreBlockingCover = true;
	RadiusMultiTarget.bAllowDeadMultiTargetUnits = false;
	RadiusMultiTarget.PsiMulti = default.NOVA_PSIMULTI;
	RadiusMultiTarget.MinRadius = default.NOVA_MINRADIUS;
	RadiusMultiTarget.MaxRadius = default.NOVA_MAXRADIUS;
	Template.AbilityMultiTargetStyle = RadiusMultiTarget;

	X2AbilityMultiTarget_Radius(Template.AbilityMultiTargetStyle).AddAbilityBonusRadius('RM_ExplodingBiotics', class'RM_Helpers'.default.RadiiBonus);

	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.NovaCooldown;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	//Don't trigger when the source is concealed
	//SourceNotConcealedCondition = new class'X2Condition_UnitProperty';
	//SourceNotConcealedCondition.ExcludeConcealed = true;
	//Template.AbilityShooterConditions.AddItem(SourceNotConcealedCondition);

	ShieldCondition = new class'X2Condition_UnitStatCheck';
	ShieldCondition.AddCheckStat(eStat_ShieldHP, 3, eCheck_GreaterThanOrEqual);
	Template.AbilityShooterConditions.AddItem(ShieldCondition);

	//// Damage Effect
	//Template.AbilityMultiTargetConditions.AddItem(default.LivingTargetUnitOnlyProperty);
	ChargeDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	ChargeDamageEffect.bIgnoreBaseDamage = true;
	ChargeDamageEffect.DamageTag = 'Nova';
	//ChargeDamageEffect.EffectDamageValue.DamageType = 'psi';
	Template.AddMultiTargetEffect(ChargeDamageEffect);


	ShieldDamageEffect = new class'X2Effect_NovaShieldEffect';
	ShieldDamageEffect.ShieldRemoval = 3;
	Template.AddShooterEffect(ShieldDamageEffect);

	RuptureEffect = new class'X2Effect_ApplyWeaponDamage';
	RuptureEffect.bIgnoreBaseDamage = true;
	RuptureEffect.bIgnoreArmor = true;
	RuptureEffect.EffectDamageValue.Rupture =  class'X2Ability_BioticAdeptSet'.default.Exposure_Rupture;
	ExposeCondition = new class'X2Condition_AbilityProperty';
	ExposeCondition.OwnerHasSoldierAbilities.AddItem('RM_ExposingBiotics');
	RuptureEffect.TargetConditions.AddItem(ExposeCondition);
	Template.AddMultiTargetEffect(RuptureEffect);


	ReaveEffect = new class'X2Effect_Reave';
	ReaveEffect.BaseShieldHPIncrease = class'X2Ability_BioticAdeptSet'.default.REAVE_BASE;
	ReaveEffect.IsMinorReave = true;
	ConsumeCondition = new class'X2Condition_AbilityProperty';
	ConsumeCondition.OwnerHasSoldierAbilities.AddItem('RM_ConsumingBiotics');
	ReaveEffect.TargetConditions.AddItem(ConsumeCondition);
	Template.AddShooterEffect(ReaveEffect);

	BonusDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	BonusDamageEffect.bIgnoreBaseDamage = true;
	BonusDamageEffect.EffectDamageValue.Damage = 1;
	DevastateCondition = new class'X2Condition_AbilityProperty';
	DevastateCondition.OwnerHasSoldierAbilities.AddItem('RM_DevastatingBiotics');
	BonusDamageEffect.TargetConditions.AddItem(DevastateCondition);
	Template.AddMultiTargetEffect(BonusDamageEffect);


	DisorientedEffect = class'X2StatusEffects'.static.CreateDisorientedStatusEffect(, , false);
	ExplodingCondition = new class'X2Condition_AbilityProperty';
	ExplodingCondition.OwnerHasSoldierAbilities.AddItem('RM_ExplodingBiotics');
	DisorientedEffect.TargetConditions.AddItem(ExplodingCondition);
	Template.AddMultiTargetEffect(DisorientedEffect);

	// Add missing animation sequences
	// HL_TeleportStart HL_TeleportStop
	AnimSets = new class'X2Effect_AdditionalAnimSets';
	AnimSets.AddAnimSetWithPath("BioticAnimations.Anims.AS_VoidStrike");
	AnimSets.BuildPersistentEffect(1, false, false, false);
	//AnimSets.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	Template.AddShooterEffect(AnimSets);

		//Targets must need healing
	Template.AbilityMultiTargetConditions.AddItem(default.LivingHostileTargetProperty);	
	Template.AbilityMultiTargetConditions.AddItem(default.GameplayVisibilityCondition);

 	Template.CustomFireAnim = 'HL_NovaA';
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;		
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;  
	Template.CinescriptCameraType = "AdvShieldBearer_EnergyShieldArmor";
	Template.bSkipPerkActivationActions = true;
	Template.bShowActivation = true;
	Template.LostSpawnIncreasePerUse = class'X2AbilityTemplateManager'.default.StandardShotLostSpawnIncreasePerUse;

 	return Template;
}

simulated function Nova_BuildVisualization(XComGameState VisualizeGameState)
{
	local XComGameStateHistory History;
	local XComGameStateContext_Ability  Context;
	local StateObjectReference InteractingUnitRef;
	local VisualizationActionMetadata EmptyTrack;
	local VisualizationActionMetadata Buildtrack;
	local X2Action_PlayAnimation PlayAnimationAction;

	History = `XCOMHISTORY;

	Context = XComGameStateContext_Ability(VisualizeGameState.GetContext());
	InteractingUnitRef = Context.InputContext.SourceObject;

	//Configure the visualization track for the shooter
	//****************************************************************************************
	BuildTrack = EmptyTrack;
	BuildTrack.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
	BuildTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
	BuildTrack.VisualizeActor = History.GetVisualizer(InteractingUnitRef.ObjectID);

	PlayAnimationAction = X2Action_PlayAnimation(class'X2Action_PlayAnimation'.static.AddToVisualizationTree(BuildTrack, Context));
	PlayAnimationAction.Params.AnimName = 'HL_NovaA';

	//OutVisualizationTracks.AddItem(BuildTrack);
}


static function X2AbilityTemplate Backlash()
{
	local X2AbilityTemplate						Template;
	local X2AbilityTargetStyle                  TargetStyle;
	local X2AbilityTrigger						Trigger;
	local X2Effect_Backlash				ShieldEffect;
	local X2Effect_PersistentStatChange         StatChange;	
	local X2AbilityCooldown_Bonus Cooldown;
	local X2AbilityCost_ActionPoints        ActionPointCost;
	local X2Effect_AdditionalAnimSets						AnimSets;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Backlash');
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_defense2";

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_AlwaysShow;
	Template.Hostility = eHostility_Neutral;

	Template.AbilityToHitCalc = default.DeadEye;

	TargetStyle = new class'X2AbilityTarget_Self';
	Template.AbilityTargetStyle = TargetStyle;

	Template.AbilityTriggers.AddItem(default.PlayerInputTrigger);

	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.Backlash_Cooldown;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	ActionPointCost.bConsumeAllPoints = true;
	Template.AbilityCosts.AddItem(ActionPointCost);

	ShieldEffect = new class'X2Effect_Backlash';
	ShieldEffect.BuildPersistentEffect(1, false, true, false, eGameRule_PlayerTurnBegin);
	ShieldEffect.SetDisplayInfo(ePerkBuff_Bonus, Template.LocFriendlyName, Template.GetMyHelpText(), Template.IconImage);
	Template.AddShooterEffect(ShieldEffect);

	AnimSets = new class'X2Effect_AdditionalAnimSets';
	AnimSets.AddAnimSetWithPath("Perk_Biotic_Generic.AS_GenericBiotic");
	AnimSets.BuildPersistentEffect(1, false, false, false);
	//AnimSets.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	Template.AddShooterEffect(AnimSets);

	Template.BuildNewGameStateFn = TypicalMoveEndAbility_BuildGameState;
	Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;
	Template.BuildInterruptGameStateFn = TypicalMoveEndAbility_BuildInterruptGameState;	

	Template.bCrossClassEligible = false;       //  this can only work with pistols, which only sharpshooters have
	Template.bShowActivation = true;

	return Template;
}


static function X2AbilityTemplate ChargeGroupStun()
{
 
 	local X2AbilityTemplate                 Template;
	local X2AbilityTrigger_EventListener    Trigger;
 // 	local X2Condition_UnitValue				ShooterCondition;	 //here
//	local X2Condition_UnitEffects			ShooterEffects;
	local X2Effect_Persistent               DisorientedEffect;
	local X2Effect_Stunned				    StunnedEffect;
	local X2AbilityMultiTarget_Radius_RMPsi RadiusMultiTarget;
	local X2Condition_UnitProperty          HealTargetCondition;
	//local X2Condition_UnitProperty						SourceNotConcealedCondition;
	local X2AbilityToHitCalc_StatCheck_UnitVsUnit    StatContest;
	local X2Condition_AbilityProperty   ExplodingCondition;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_ChargeGroupStun');

		// This will be a stat contest
	StatContest = new class'X2AbilityToHitCalc_StatCheck_UnitVsUnit';
	StatContest.AttackerStat = eStat_PsiOffense;
	Template.AbilityToHitCalc = StatContest;
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AbilityTargetStyle = default.SelfTarget;
	Template.eAbilityIconBehaviorHUD = eAbilityIconBehavior_NeverShow;
	Template.Hostility = eHostility_Neutral;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_blossom";
	
	Trigger = new class'X2AbilityTrigger_EventListener';
	Trigger.ListenerData.Deferral = ELD_OnStateSubmitted;
	Trigger.ListenerData.EventID = 'RM_Charge';
	Trigger.ListenerData.Filter = eFilter_Unit;
 	Trigger.ListenerData.EventFn = class'XComGameState_Ability'.static.AbilityTriggerEventListener_Self;
	Trigger.ListenerData.Priority = 45; //This ability must get triggered after the rest of the on-death listeners (namely, after mind-control effects get removed)
	Template.AbilityTriggers.AddItem(Trigger);

	RadiusMultiTarget = new class'X2AbilityMultiTarget_Radius_RMPsi';
	RadiusMultiTarget.fTargetRadius = 6;
	RadiusMultiTarget.bIgnoreBlockingCover = true;
	RadiusMultiTarget.bAllowDeadMultiTargetUnits = false;
	RadiusMultiTarget.PsiMulti = default.NOVA_PSIMULTI;
	RadiusMultiTarget.MinRadius = 4.5;
	RadiusMultiTarget.MaxRadius = 9;
	Template.AbilityMultiTargetStyle = RadiusMultiTarget;

	X2AbilityMultiTarget_Radius(Template.AbilityMultiTargetStyle).AddAbilityBonusRadius('RM_ExplodingBiotics', class'RM_Helpers'.default.RadiiBonus);

	//Don't trigger when the source is concealed
	//SourceNotConcealedCondition = new class'X2Condition_UnitProperty';
	//SourceNotConcealedCondition.ExcludeConcealed = true;
	//Template.AbilityShooterConditions.AddItem(SourceNotConcealedCondition);
	

	// On hit effects
	//  Stunned effect for 1 or 2 unblocked hit
	DisorientedEffect = class'X2StatusEffects'.static.CreateDisorientedStatusEffect(, , false);
	DisorientedEffect.MinStatContestResult = 0;
	DisorientedEffect.MaxStatContestResult = 1;
	DisorientedEffect.bRemoveWhenSourceDies = false;
	Template.AddMultiTargetEffect(DisorientedEffect);

	//  Stunned effect for 3 or 4 unblocked hit
	StunnedEffect = class'X2StatusEffects'.static.CreateStunnedStatusEffect(1, 100, false);
	StunnedEffect.MinStatContestResult = 2;
	StunnedEffect.MaxStatContestResult = 3;
	StunnedEffect.bRemoveWhenSourceDies = false;
	Template.AddMultiTargetEffect(StunnedEffect);

	//  Stunned effect for 3 or 4 unblocked hit
	StunnedEffect = class'X2StatusEffects'.static.CreateStunnedStatusEffect(2, 100, false);
	StunnedEffect.MinStatContestResult = 3;
	StunnedEffect.MaxStatContestResult = 4;
	StunnedEffect.bRemoveWhenSourceDies = false;
	Template.AddMultiTargetEffect(StunnedEffect);


	//  Stunned effect for 3 or 4 unblocked hit
	StunnedEffect = class'X2StatusEffects'.static.CreateStunnedStatusEffect(3, 100, false);
	StunnedEffect.MinStatContestResult = 5;
	StunnedEffect.MaxStatContestResult = 0;
	StunnedEffect.bRemoveWhenSourceDies = false;
	Template.AddMultiTargetEffect(StunnedEffect);


		//Targets must need healing
	Template.AbilityMultiTargetConditions.AddItem(default.LivingHostileTargetProperty);	
	Template.AbilityMultiTargetConditions.AddItem(default.GameplayVisibilityCondition);

// 	Template.CustomSelfFireAnim = 'FF_FireMedkitSelf';
	Template.BuildNewGameStateFn = TypicalAbility_BuildGameState;		
	//Template.BuildVisualizationFn = TypicalAbility_BuildVisualization;  

	Template.bShowActivation = true;

 	return Template;
}

static function X2AbilityTemplate Charge()
{
	local X2AbilityTemplate Template;
	local X2AbilityCost_ActionPoints ActionPointCost;
	local X2AbilityCooldown_Bonus Cooldown;
	local X2AbilityTarget_Cursor CursorTarget;
	local X2AbilityMultiTarget_Radius RadiusMultiTarget;
	local X2AbilityTrigger_PlayerInput InputTrigger;
	local X2Effect_AdditionalAnimSets						AnimSets;
	local X2Effect_ApplyWeaponDamage ChargeDamageEffect;
	local X2Effect_ApplyWeaponDamage        DamageEffect, BonusDamageEffect;
	local X2Effect_ApplyWeaponDamage    RuptureEffect;
	local X2Condition_AbilityProperty   ExposeCondition, DevastateCondition;
	local X2Effect_Reave					ReaveEffect;
	local X2Condition_AbilityProperty		ConsumeCondition;
	local X2Effect_GrantActionPoints            PointEffect;

	`CREATE_X2ABILITY_TEMPLATE(Template, 'RM_Charge');

	Template.AbilitySourceName = 'eAbilitySource_Psionic';
	Template.eAbilityIconBehaviorHUD = EAbilityIconBehavior_AlwaysShow;
	Template.IconImage = "img:///XPerkIconPack.UIPerk_psi_move2";

	ActionPointCost = new class'X2AbilityCost_ActionPoints';
	ActionPointCost.iNumPoints = 1;
	Template.AbilityCosts.AddItem(ActionPointCost);

	Cooldown = new class'X2AbilityCooldown_Bonus';
	Cooldown.iNumTurns = default.ChargeCooldown;
	Cooldown.iModifier = 1;
	Cooldown.ModifierAbility = 'RM_BioticNerves';
	Template.AbilityCooldown = Cooldown;

	//Template.TargetingMethod = class'X2TargetingMethod_Teleport';

	InputTrigger = new class'X2AbilityTrigger_PlayerInput';
	Template.AbilityTriggers.AddItem(InputTrigger);

	Template.AbilityToHitCalc = default.DeadEye;

	// Targeting Details
	// Can only shoot visible enemies
	Template.AbilityTargetConditions.AddItem(default.GameplayVisibilityCondition);
	// Can't target dead; Can't target friendlies
	Template.AbilityTargetConditions.AddItem(default.LivingHostileTargetProperty);
	// Can't shoot while dead
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	// Only at single targets that are in range.
	Template.AbilityTargetStyle = default.SimpleSingleTarget;

	// Add missing animation sequences
	// HL_TeleportStart HL_TeleportStop
	AnimSets = new class'X2Effect_AdditionalAnimSets';
	AnimSets.AddAnimSetWithPath("BioticAnimations.Anims.AS_VoidStrike");
	AnimSets.BuildPersistentEffect(1, false, false, false);
	AnimSets.SetDisplayInfo(ePerkBuff_Passive, Template.LocFriendlyName, Template.GetMyLongDescription(), Template.IconImage, false, , Template.AbilitySourceName);
	Template.AddShooterEffect(AnimSets);

	PointEffect = new class'X2Effect_GrantActionPoints';
	PointEffect.NumActionPoints = 1;
	PointEffect.PointType = class'X2CharacterTemplateManager'.default.MoveActionPoint;
	Template.AddShooterEffect(PointEffect);

	//RadiusMultiTarget = new class'X2AbilityMultiTarget_Radius';
	//RadiusMultiTarget.fTargetRadius = 0.25; // small amount so it just grabs one tile
	//Template.AbilityMultiTargetStyle = RadiusMultiTarget;

	// Shooter Conditions
	Template.AbilityShooterConditions.AddItem(default.LivingShooterProperty);
	Template.AddShooterEffectExclusions();

	//// Damage Effect
	//Template.AbilityMultiTargetConditions.AddItem(default.LivingTargetUnitOnlyProperty);
	ChargeDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	ChargeDamageEffect.bIgnoreBaseDamage = true;
	ChargeDamageEffect.DamageTag = 'Charge';
//	ChargeDamageEffect.EffectDamageValue.DamageType = 'Melee';
	Template.AddTargetEffect(ChargeDamageEffect);

	RuptureEffect = new class'X2Effect_ApplyWeaponDamage';
	RuptureEffect.bIgnoreBaseDamage = true;
	RuptureEffect.bIgnoreArmor = true;
	RuptureEffect.EffectDamageValue.Rupture =  class'X2Ability_BioticAdeptSet'.default.Exposure_Rupture;
	ExposeCondition = new class'X2Condition_AbilityProperty';
	ExposeCondition.OwnerHasSoldierAbilities.AddItem('RM_ExposingBiotics');
	RuptureEffect.TargetConditions.AddItem(ExposeCondition);
	Template.AddTargetEffect(RuptureEffect);


	ReaveEffect = new class'X2Effect_Reave';
	ReaveEffect.BaseShieldHPIncrease = class'X2Ability_BioticAdeptSet'.default.REAVE_BASE;
	ReaveEffect.IsMinorReave = true;
	ConsumeCondition = new class'X2Condition_AbilityProperty';
	ConsumeCondition.OwnerHasSoldierAbilities.AddItem('RM_ConsumingBiotics');
	ReaveEffect.TargetConditions.AddItem(ConsumeCondition);
	Template.AddShooterEffect(ReaveEffect);

	BonusDamageEffect = new class'X2Effect_ApplyWeaponDamage';
	BonusDamageEffect.bIgnoreBaseDamage = true;
	BonusDamageEffect.EffectDamageValue.Damage = 1;
	DevastateCondition = new class'X2Condition_AbilityProperty';
	DevastateCondition.OwnerHasSoldierAbilities.AddItem('RM_DevastatingBiotics');
	BonusDamageEffect.TargetConditions.AddItem(DevastateCondition);
	Template.AddTargetEffect(BonusDamageEffect);

	Template.ModifyNewContextFn = Teleport_ModifyActivatedAbilityContext;
	Template.BuildNewGameStateFn = Teleport_BuildGameState;
	Template.BuildVisualizationFn = Teleport_BuildVisualization;
	Template.CinescriptCameraType = "Cyberus_Teleport";
	Template.bShowActivation = true;

	Template.PostActivationEvents.AddItem('RM_Charge');
	Template.AdditionalAbilities.AddItem('RM_ChargeGroupStun');
	Template.ActivationSpeech = 'Reaper';
	Template.LostSpawnIncreasePerUse = class'X2AbilityTemplateManager'.default.StandardShotLostSpawnIncreasePerUse;

	return Template;
}


static simulated function Teleport_ModifyActivatedAbilityContext(XComGameStateContext Context)
{
	local XComGameState_Unit UnitState, EnemyState;
	local XComGameStateContext_Ability AbilityContext;
	local XComGameStateHistory History;
	local PathPoint NextPoint, EmptyPoint;
	local PathingInputData InputData;
	local XComWorldData World;
	local vector NewLocation;
	local TTile NewTileLocation, EnemyTileLocation;
	local bool FoundChargeTile;

	History = `XCOMHISTORY;
	World = `XWORLD;

	AbilityContext = XComGameStateContext_Ability(Context);
	//`assert(AbilityContext.InputContext.TargetLocations.Length > 0);
	
	UnitState = XComGameState_Unit(History.GetGameStateForObjectID(AbilityContext.InputContext.SourceObject.ObjectID));
	EnemyState = XComGameState_Unit(History.GetGameStateForObjectID(AbilityContext.InputContext.PrimaryTarget.ObjectID));

	// Build the MovementData for the path
	// First posiiton is the current location
	InputData.MovementTiles.AddItem(UnitState.TileLocation);

	NextPoint.Position = World.GetPositionFromTileCoordinates(UnitState.TileLocation);
	NextPoint.Traversal = eTraversal_Teleport;
	NextPoint.PathTileIndex = 0;
	InputData.MovementData.AddItem(NextPoint);

	// Second posiiton is near the enemy's position
	//`assert(EnemyTileLocation != none);
	EnemyState.GetKeystoneVisibilityLocation(EnemyTileLocation);
	FoundChargeTile = class'RM_Helpers'.static.GetChargeTileNearTile(EnemyTileLocation, 2, 4);


	//NewLocation = AbilityContext.InputContext.TargetLocations[0];
	//NewTileLocation = World.GetTileCoordinatesFromPosition(NewLocation);
	NewLocation = World.GetPositionFromTileCoordinates(EnemyTileLocation);
	
	NextPoint = EmptyPoint;
	NextPoint.Position = NewLocation;
	NextPoint.Traversal = eTraversal_Landing;
	NextPoint.PathTileIndex = 1;
	InputData.MovementData.AddItem(NextPoint);
	InputData.MovementTiles.AddItem(EnemyTileLocation);

    //Now add the path to the input context
	InputData.MovingUnitRef = UnitState.GetReference();
	AbilityContext.InputContext.MovementPaths.AddItem(InputData);
}

static simulated function XComGameState Teleport_BuildGameState(XComGameStateContext Context)
{
	local XComGameState NewGameState;
	local XComGameState_Unit UnitState;
	local XComGameStateContext_Ability AbilityContext;
	local vector NewLocation;
	local TTile NewTileLocation;
	local XComWorldData World;
	local X2EventManager EventManager;
	local int LastElementIndex;

	World = `XWORLD;
	EventManager = `XEVENTMGR;

	//Build the new game state frame
	NewGameState = TypicalAbility_BuildGameState(Context);

	AbilityContext = XComGameStateContext_Ability(NewGameState.GetContext());	
	UnitState = XComGameState_Unit(NewGameState.CreateStateObject(class'XComGameState_Unit', AbilityContext.InputContext.SourceObject.ObjectID));

	LastElementIndex = AbilityContext.InputContext.MovementPaths[0].MovementData.Length - 1;

	// Set the unit's new location
	// The last position in MovementData will be the end location
	`assert(LastElementIndex > 0);
	NewLocation = AbilityContext.InputContext.MovementPaths[0].MovementData[LastElementIndex].Position;
	NewTileLocation = World.GetTileCoordinatesFromPosition(NewLocation);
	UnitState.SetVisibilityLocation(NewTileLocation);

	NewGameState.AddStateObject(UnitState);

	AbilityContext.ResultContext.bPathCausesDestruction = MoveAbility_StepCausesDestruction(UnitState, AbilityContext.InputContext, 0, AbilityContext.InputContext.MovementPaths[0].MovementTiles.Length - 1);
	MoveAbility_AddTileStateObjects(NewGameState, UnitState, AbilityContext.InputContext, 0, AbilityContext.InputContext.MovementPaths[0].MovementTiles.Length - 1);

	EventManager.TriggerEvent('ObjectMoved', UnitState, UnitState, NewGameState);
	EventManager.TriggerEvent('UnitMoveFinished', UnitState, UnitState, NewGameState);

	//Return the game state we have created
	return NewGameState;
}

simulated function Teleport_BuildVisualization(XComGameState VisualizeGameState)
{
	local XComGameStateHistory History;
	local XComGameStateContext_Ability  AbilityContext;
	local StateObjectReference InteractingUnitRef;
	local X2AbilityTemplate AbilityTemplate;
	local VisualizationActionMetadata EmptyTrack, BuildTrack;
	local X2Action_PlaySoundAndFlyOver SoundAndFlyover;
	local int i, j;
	local XComGameState_WorldEffectTileData WorldDataUpdate;
	local X2Action_MoveTurn MoveTurnAction;
	local X2VisualizerInterface TargetVisualizerInterface;
	local X2Action_PlayEffect EffectAction;
	local XComWorldData World;
	local vector TargetLocation;
	local TTile TargetTile;
	local TTile EnemyTileLocation;
	local bool FoundChargeTile;
	local XComGameState_Unit  EnemyState;
	local name         ApplyResult;

	History = `XCOMHISTORY;
	World = `XWORLD;
	AbilityContext = XComGameStateContext_Ability(VisualizeGameState.GetContext());
	InteractingUnitRef = AbilityContext.InputContext.SourceObject;
	EnemyState = XComGameState_Unit(History.GetGameStateForObjectID(AbilityContext.InputContext.SourceObject.ObjectID));
	EnemyState.GetKeystoneVisibilityLocation(EnemyTileLocation);
	FoundChargeTile = class'RM_Helpers'.static.GetChargeTileNearTile(EnemyTileLocation, 2, 4);

	AbilityTemplate = class'XComGameState_Ability'.static.GetMyTemplateManager().FindAbilityTemplate(AbilityContext.InputContext.AbilityTemplateName);

	//****************************************************************************************
	//Configure the visualization track for the source
	//****************************************************************************************
	BuildTrack = EmptyTrack;
	BuildTrack.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
	BuildTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
	BuildTrack.VisualizeActor = History.GetVisualizer(InteractingUnitRef.ObjectID);

	SoundAndFlyOver = X2Action_PlaySoundAndFlyOver(class'X2Action_PlaySoundAndFlyover'.static.AddToVisualizationTree(BuildTrack, AbilityContext));
	SoundAndFlyOver.SetSoundAndFlyOverParameters(None, AbilityTemplate.LocFlyOverText, '', eColor_Good);

	// Turn to face the target action. The target location is the center of the ability's radius, stored in the 0 index of the TargetLocations
	MoveTurnAction = X2Action_MoveTurn(class'X2Action_MoveTurn'.static.AddToVisualizationTree(BuildTrack, AbilityContext));
	MoveTurnAction.m_vFacePoint =  World.GetPositionFromTileCoordinates(EnemyTileLocation);


	// Display the Warning FX (convert to tile and back to vector because stage 2 is at the GetPositionFromTileCoordinates coord
//
	//EffectAction = X2Action_PlayEffect(class'X2Action_PlayEffect'.static.AddToVisualizationTrack(BuildTrack, AbilityContext));
	//EffectAction.EffectName = "FX_Psi_Null_Lance.P_Psi_Null_Lance_Projectile";
	//TargetLocation = World.GetPositionFromTileCoordinates(EnemyTileLocation);
	//TargetTile = World.GetTileCoordinatesFromPosition(TargetLocation);
//
	//EffectAction.EffectLocation = World.GetPositionFromTileCoordinates(TargetTile);
//
	//OutVisualizationTracks.AddItem(BuildTrack);
//
	//// move action
//
	//BuildTrack = EmptyTrack;
	//BuildTrack.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
	//BuildTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
	//BuildTrack.TrackActor = History.GetVisualizer(InteractingUnitRef.ObjectID);

	class'X2VisualizerHelpers'.static.ParsePath(AbilityContext, BuildTrack);



	//OutVisualizationTracks.AddItem(BuildTrack);
	
	//****************************************************************************************

	foreach VisualizeGameState.IterateByClassType(class'XComGameState_WorldEffectTileData', WorldDataUpdate)
	{
		BuildTrack = EmptyTrack;
		BuildTrack.VisualizeActor = none;
		BuildTrack.StateObject_NewState = WorldDataUpdate;
		BuildTrack.StateObject_OldState = WorldDataUpdate;

		for (i = 0; i < AbilityTemplate.AbilityTargetEffects.Length; ++i)
		{
			AbilityTemplate.AbilityTargetEffects[i].AddX2ActionsForVisualization(VisualizeGameState, BuildTrack, AbilityContext.FindTargetEffectApplyResult(AbilityTemplate.AbilityTargetEffects[i]));
		}

		//OutVisualizationTracks.AddItem(BuildTrack);
	}

	//****************************************************************************************
	//Configure the visualization track for the targets
	//****************************************************************************************

		InteractingUnitRef = AbilityContext.InputContext.PrimaryTarget;
		BuildTrack = EmptyTrack;
		BuildTrack.StateObject_OldState = History.GetGameStateForObjectID(InteractingUnitRef.ObjectID, eReturnType_Reference, VisualizeGameState.HistoryIndex - 1);
		BuildTrack.StateObject_NewState = VisualizeGameState.GetGameStateForObjectID(InteractingUnitRef.ObjectID);
		BuildTrack.VisualizeActor = History.GetVisualizer(InteractingUnitRef.ObjectID);

		
		class'X2Action_WaitForAbilityEffect'.static.AddToVisualizationTree(BuildTrack, AbilityContext);

		TargetVisualizerInterface = X2VisualizerInterface(BuildTrack.VisualizeActor);
		if( TargetVisualizerInterface != none )
		{
			//Allow the visualizer to do any custom processing based on the new game state. For example, units will create a death action when they reach 0 HP.
			TargetVisualizerInterface.BuildAbilityEffectsVisualization(VisualizeGameState, BuildTrack);
		}
//
		//if (BuildTrack.TrackActions.Length > 0)
		//{
			//OutVisualizationTracks.AddItem(BuildTrack);
		//}
	
}

